import { SimulationStatus, VIRTUAL_BASE } from '../providers';
export function breakDownTenderlySimulationError(tokenIn, tokenOut, data) {
    if (data) {
        switch (data) {
            case '0x739dbe52': // V3TooMuchRequested
            case '0x39d35496': // V3TooLittleReceived
            case '0x849eaf98': // V2TooLittleReceived
            case '0x8ab0bc16': // V2TooMuchRequested
            case '0x08c379a000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000025556e697377617056323a20494e53554646494349454e545f4f55545055545f414d4f554e54000000000000000000000000000000000000000000000000000000': // INSUFFICIENT_OUTPUT_AMOUNT
            case '0x08c379a0000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000034949410000000000000000000000000000000000000000000000000000000000': // IIA
                return SimulationStatus.SlippageTooLow;
            case '0x08c379a0000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000145452414e534645525f46524f4d5f4641494c4544000000000000000000000000': // TRANSFER_FROM_FAILED
                return SimulationStatus.TransferFromFailed;
            case '0x675cae38': // InsufficientToken
                if (tokenIn.address.toLowerCase() ===
                    VIRTUAL_BASE.address.toLowerCase() ||
                    tokenOut.address.toLowerCase() === VIRTUAL_BASE.address.toLowerCase()) {
                    // if this is from virtual, we'd guess it's due to slippage too low, although it might be due to something else
                    return SimulationStatus.SlippageTooLow;
                }
                // Otherwise we don't wanna guess, just return generic failed.
                return SimulationStatus.Failed;
            default: // we don't know why onchain execution reverted, just return generic failed.
                return SimulationStatus.Failed;
        }
    }
    return SimulationStatus.Failed;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVuZGVybHlTaW11bGF0aW9uRXJyb3JCcmVha0Rvd24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvdXRpbC90ZW5kZXJseVNpbXVsYXRpb25FcnJvckJyZWFrRG93bi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQSxPQUFPLEVBQUUsZ0JBQWdCLEVBQUUsWUFBWSxFQUFFLE1BQU0sY0FBYyxDQUFDO0FBRTlELE1BQU0sVUFBVSxnQ0FBZ0MsQ0FDOUMsT0FBYyxFQUNkLFFBQWUsRUFDZixJQUFhO0lBRWIsSUFBSSxJQUFJLEVBQUU7UUFDUixRQUFRLElBQUksRUFBRTtZQUNaLEtBQUssWUFBWSxDQUFDLENBQUMscUJBQXFCO1lBQ3hDLEtBQUssWUFBWSxDQUFDLENBQUMsc0JBQXNCO1lBQ3pDLEtBQUssWUFBWSxDQUFDLENBQUMsc0JBQXNCO1lBQ3pDLEtBQUssWUFBWSxDQUFDLENBQUMscUJBQXFCO1lBQ3hDLEtBQUssNFFBQTRRLENBQUMsQ0FBQyw2QkFBNkI7WUFDaFQsS0FBSyw0TUFBNE0sRUFBRSxNQUFNO2dCQUN2TixPQUFPLGdCQUFnQixDQUFDLGNBQWMsQ0FBQztZQUN6QyxLQUFLLDRNQUE0TSxFQUFFLHVCQUF1QjtnQkFDeE8sT0FBTyxnQkFBZ0IsQ0FBQyxrQkFBa0IsQ0FBQztZQUM3QyxLQUFLLFlBQVksRUFBRSxvQkFBb0I7Z0JBQ3JDLElBQ0UsT0FBTyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUU7b0JBQzNCLFlBQVksQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFO29CQUNwQyxRQUFRLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxLQUFLLFlBQVksQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLEVBQ3JFO29CQUNBLCtHQUErRztvQkFDL0csT0FBTyxnQkFBZ0IsQ0FBQyxjQUFjLENBQUM7aUJBQ3hDO2dCQUVELDhEQUE4RDtnQkFDOUQsT0FBTyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUM7WUFDakMsU0FBUyw0RUFBNEU7Z0JBQ25GLE9BQU8sZ0JBQWdCLENBQUMsTUFBTSxDQUFDO1NBQ2xDO0tBQ0Y7SUFFRCxPQUFPLGdCQUFnQixDQUFDLE1BQU0sQ0FBQztBQUNqQyxDQUFDIn0=